// JavaScript files are compiled and minified during the build process to the assets/built folder. See available scripts in the package.json file.

// Import Swiper styles
import "swiper/css/bundle";

// Import CSS
import "../css/index.css";

// Import JS
import { toggleDarkMode } from "./darkMode";
import { initSliders } from "./initSliders";
import { loadMore } from "./loadMore";
import { copyToClipboard } from "./copyToClipBoard";
import { hideHeader, showSubNav } from "./header";
import { initMobileMenu } from "./mobileMenu";
import { togglePlan } from "./membershipToggle";
import { scrollTop } from "./scrollTop";
import { centerSwiperBtns } from "./centerSliderBtns";
import { calcHeight } from "./membershipCard";
import { scrollAnimate } from "./scrollAnimate";
import { changeTwitterCardTheme } from "./twitterTheme";
import { initMobileSubmenus } from "./burger-submenu";

initMobileSubmenus();
toggleDarkMode(changeTwitterCardTheme);
initSliders();
loadMore();
copyToClipboard();
hideHeader();
showSubNav();
initMobileMenu();
scrollTop();
togglePlan();
centerSwiperBtns();
calcHeight();
scrollAnimate();

window.addEventListener("load", changeTwitterCardTheme);
window.addEventListener("resize", centerSwiperBtns);
