# Spotlight

This is a fork of the spotlight theme, for https://hyperobject.ink

Spotlight - theme for effortlessly elevating your publication to new heights. A sharp and minimalist design boasting premium features for your exceptional blogging journey.

&nbsp;

## Useful links

**Demos: https://spotlight.highfivethemes.com/**
**Documentation: https://highfivethemes.gitbook.io/spotlight-user-documentation/**

&nbsp;

## Features

1. Dark mode with option for dark mode publication logo
2. Custom Archive (All Posts), Authors, Categories (tags), Wide-post, Account, Sign In/Up, Subscribe, Error 404 and Membership pages
3. 6 Hero-section options
4. 10 Header layout options
5. 4 Home page postfeed layout options
6. Custom background and button colors
7. 3 variants of border-radius for buttons, images and containers
8. 4 font-pairings options
9. Translation support
10. Optional image lightbox with zoom for posts

## Installation instructions

1. Go to **Settings > Design** from the admin menu
2. Click **Change theme** in the bottom left corner
3. Then click the **Upload theme** button in the upper right corner
4. Click inside the upload box to select a **spotlight.zip**, or drag-and-drop the **spotlight.zip** into the upload box
   5.Once uploaded, click **Activate** to activate the theme

&nbsp;

## Theme structure

The main templates files are:

- [`default.hbs`](default.hbs) - The main template file
- [`index.hbs`](index.hbs) - Used for the home page
- [`post.hbs`](post.hbs) - Used for individual posts
- [`custom-wide-post.hbs`](custom-wide-post.hbs) - Used for individual posts with wide post head
- [`page.hbs`](page.hbs) - Used for individual pages
- [`archive.hbs`](archive.hbs) - Used for Archive (All Posts) page
- [`tag.hbs`](tag.hbs) - Used for tag archives
- [`author.hbs`](author.hbs) - Used for author archives
- [`custom-authors.hbs`](custom-authors.hbs) - Used for publication's Authors page
- [`custom-categories.hbs`](custom-categories.hbs) - Used for publication's Categories (Tags) page
- [`error-404.hbs`](error-404.hbs) - Used for 404 Error page
- [`custom-sign-in.hbs`](custom-sign-in.hbs) - Used for custom Sign In page
- [`custom-sign-up.hbs`](custom-sign-up.hbs) - Used for custom Sign Up page
- [`custom-subscribe.hbs`](custom-subscribe.hbs) - Used for custom Subscribe page
- [`custom-memberships.hbs`](custom-memberships.hbs) - Used for custom Memberships page
- [`custom-account.hbs`](custom-account.hbs) - Used for custom Account page

&nbsp;

## Development guide

**Spotlight** theme provides a first-class development experience out of the box.

### Setup

To see realtime changes during development, symlink the Spotlight theme folder to the `content/themes` folder in your local Ghost install.

```bash
ln -s /path/to/spotlight /ghost/content/themes/spotlight
```

Restart Ghost and select the **Spotlight** theme from **Settings**.

From the theme's root directory, install the dependencies:

```bash
npm install
```

If Node isn't installed, follow the [official Node installation guide](https://nodejs.org/).

### Start development mode

From the Spotlight theme folder, start development mode:

```bash
npm run dev
```

Changes you make to your styles, scripts, and Handlebars files will show up automatically in the browser. CSS and Javascript will be compiled and output to the `built` folder.

Press `ctrl + c` in the terminal to exit development mode.

### Build, zip, and test your theme

Compile your CSS and JavaScript assets for production with the following command:

```bash
npm run build
```

Create a zip archive:

```bash
npm run zip
```

Use `gscan` to test your theme for compatibility with Ghost:

```bash
npm run test
```

&nbsp;

## Copyright & License

Copyright (c) 2024 HighFiveThemes - Released under the MIT license.
